/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import slimeknights.mantle.util.JsonHelper;

public class SizedIngredient
implements Predicate<class_1799> {
    public static final SizedIngredient EMPTY = SizedIngredient.of(class_1856.field_9017, 0);
    private final class_1856 ingredient;
    private final int amountNeeded;
    private WeakReference<class_1799[]> lastIngredientMatch;
    private List<class_1799> matchingStacks;

    public static SizedIngredient of(class_1856 ingredient) {
        return SizedIngredient.of(ingredient, 1);
    }

    public static SizedIngredient fromItems(int amountNeeded, class_1935 ... items) {
        return SizedIngredient.of(class_1856.method_8091((class_1935[])items), amountNeeded);
    }

    public static SizedIngredient fromItems(class_1935 ... items) {
        return SizedIngredient.fromItems(1, items);
    }

    public static SizedIngredient fromTag(class_6862<class_1792> tag, int amountNeeded) {
        return SizedIngredient.of(class_1856.method_8106(tag), amountNeeded);
    }

    public static SizedIngredient fromTag(class_6862<class_1792> tag) {
        return SizedIngredient.fromTag(tag, 1);
    }

    @Override
    public boolean test(class_1799 stack) {
        return stack.method_7947() >= this.amountNeeded && this.ingredient.method_8093(stack);
    }

    public boolean hasNoMatchingStacks() {
        return this.ingredient.method_8103();
    }

    public List<class_1799> getMatchingStacks() {
        class_1799[] ingredientMatch = this.ingredient.method_8105();
        if (this.matchingStacks == null || this.lastIngredientMatch.get() != ingredientMatch) {
            this.matchingStacks = Arrays.stream(ingredientMatch).map(stack -> {
                if (stack.method_7947() != this.amountNeeded) {
                    stack = stack.method_7972();
                    stack.method_7939(this.amountNeeded);
                }
                return stack;
            }).collect(Collectors.toList());
            this.lastIngredientMatch = new WeakReference<class_1799[]>(ingredientMatch);
        }
        return this.matchingStacks;
    }

    public void write(class_2540 buffer) {
        buffer.method_10804(this.amountNeeded);
        this.ingredient.method_8088(buffer);
    }

    public JsonObject serialize() {
        JsonElement ingredient = this.ingredient.method_8089();
        JsonObject json = null;
        if (ingredient.isJsonObject() && ((json = ingredient.getAsJsonObject()).has("ingredient") || json.has("amount_needed"))) {
            json = null;
        }
        if (json == null) {
            json = new JsonObject();
            json.add("ingredient", ingredient);
        }
        if (this.amountNeeded != 1) {
            json.addProperty("amount_needed", (Number)this.amountNeeded);
        }
        return json;
    }

    public static SizedIngredient read(class_2540 buffer) {
        int amountNeeded = buffer.method_10816();
        class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
        return SizedIngredient.of(ingredient, amountNeeded);
    }

    public static SizedIngredient deserialize(JsonObject json) {
        int amountNeeded = class_3518.method_15282((JsonObject)json, (String)"amount_needed", (int)1);
        class_1856 ingredient = json.has("ingredient") ? class_1856.method_52177((JsonElement)JsonHelper.getElement(json, "ingredient")) : class_1856.method_52177((JsonElement)json);
        return SizedIngredient.of(ingredient, amountNeeded);
    }

    private SizedIngredient(class_1856 ingredient, int amountNeeded) {
        this.ingredient = ingredient;
        this.amountNeeded = amountNeeded;
    }

    public static SizedIngredient of(class_1856 ingredient, int amountNeeded) {
        return new SizedIngredient(ingredient, amountNeeded);
    }

    public class_1856 getIngredient() {
        return this.ingredient;
    }

    public int getAmountNeeded() {
        return this.amountNeeded;
    }
}

